package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Tf072001;
import com.xforceplus.ultraman.app.sdktest.service.ITf072001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Tf072001Controller {

  @Autowired
  private ITf072001Service tf072001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tf072001 ${table.comment}
   * @return
   */
  @GetMapping("/tf072001s" )
  public XfR getTf072001s(XfPage page, Tf072001 tf072001) {
    return XfR.ok(tf072001ServiceImpl.page(page, Wrappers.query(tf072001)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tf072001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tf072001ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tf072001 ${table.comment}
   * @return XfR
   */
  @PostMapping("/tf072001s")
  public XfR save(@RequestBody Tf072001 tf072001) {
     return XfR.ok(tf072001ServiceImpl.save(tf072001));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tf072001 ${table.comment}
   * @return XfR
   */
  @PutMapping("/tf072001s/{id}")
  public XfR putUpdate(@RequestBody Tf072001 tf072001,@PathVariable Long id) {
      tf072001.setId(id);
      return XfR.ok(tf072001ServiceImpl.updateById(tf072001));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tf072001 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tf072001s/{id}")
  public XfR patchUpdate(@RequestBody Tf072001 tf072001,@PathVariable Long id) {
      Tf072001 uptf072001 = tf072001ServiceImpl.getById(id);
      if(uptf072001 != null){
        uptf072001 = ObjectCopyUtils.copyProperties(tf072001,uptf072001,true);
      }
      return XfR.ok(tf072001ServiceImpl.updateById(uptf072001));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tf072001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tf072001ServiceImpl.removeById(id));
  }

  @PostMapping("/tf072001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tf072001");
     params.put("request", condition);

     return XfR.ok(tf072001ServiceImpl.querys(params));
  }

}
