package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Tf072002;
import com.xforceplus.ultraman.app.sdktest.service.ITf072002Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Tf072002Controller {

  @Autowired
  private ITf072002Service tf072002ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tf072002 ${table.comment}
   * @return
   */
  @GetMapping("/tf072002s" )
  public XfR getTf072002s(XfPage page, Tf072002 tf072002) {
    return XfR.ok(tf072002ServiceImpl.page(page, Wrappers.query(tf072002)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tf072002s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tf072002ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tf072002 ${table.comment}
   * @return XfR
   */
  @PostMapping("/tf072002s")
  public XfR save(@RequestBody Tf072002 tf072002) {
     return XfR.ok(tf072002ServiceImpl.save(tf072002));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tf072002 ${table.comment}
   * @return XfR
   */
  @PutMapping("/tf072002s/{id}")
  public XfR putUpdate(@RequestBody Tf072002 tf072002,@PathVariable Long id) {
      tf072002.setId(id);
      return XfR.ok(tf072002ServiceImpl.updateById(tf072002));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tf072002 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tf072002s/{id}")
  public XfR patchUpdate(@RequestBody Tf072002 tf072002,@PathVariable Long id) {
      Tf072002 uptf072002 = tf072002ServiceImpl.getById(id);
      if(uptf072002 != null){
        uptf072002 = ObjectCopyUtils.copyProperties(tf072002,uptf072002,true);
      }
      return XfR.ok(tf072002ServiceImpl.updateById(uptf072002));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tf072002s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tf072002ServiceImpl.removeById(id));
  }

  @PostMapping("/tf072002s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tf072002");
     params.put("request", condition);

     return XfR.ok(tf072002ServiceImpl.querys(params));
  }

}
