package com.xforceplus.ultraman.app.sdktest.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.sdktest.entity.Tftf1;
import com.xforceplus.ultraman.app.sdktest.service.ITftf1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-08-06
 */
@RestController
public class Tftf1Controller {

  @Autowired
  private ITftf1Service tftf1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tftf1 ${table.comment}
   * @return
   */
  @GetMapping("/tftf1s" )
  public XfR getTftf1s(XfPage page, Tftf1 tftf1) {
    return XfR.ok(tftf1ServiceImpl.page(page, Wrappers.query(tftf1)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tftf1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tftf1ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tftf1 ${table.comment}
   * @return XfR
   */
  @PostMapping("/tftf1s")
  public XfR save(@RequestBody Tftf1 tftf1) {
     return XfR.ok(tftf1ServiceImpl.save(tftf1));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tftf1 ${table.comment}
   * @return XfR
   */
  @PutMapping("/tftf1s/{id}")
  public XfR putUpdate(@RequestBody Tftf1 tftf1,@PathVariable Long id) {
      tftf1.setId(id);
      return XfR.ok(tftf1ServiceImpl.updateById(tftf1));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tftf1 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tftf1s/{id}")
  public XfR patchUpdate(@RequestBody Tftf1 tftf1,@PathVariable Long id) {
      Tftf1 uptftf1 = tftf1ServiceImpl.getById(id);
      if(uptftf1 != null){
        uptftf1 = ObjectCopyUtils.copyProperties(tftf1,uptftf1,true);
      }
      return XfR.ok(tftf1ServiceImpl.updateById(uptftf1));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tftf1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tftf1ServiceImpl.removeById(id));
  }

  @PostMapping("/tftf1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tftf1");
     params.put("request", condition);

     return XfR.ok(tftf1ServiceImpl.querys(params));
  }

}
