package com.xforceplus.ultraman.app.stydyxiahao.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.stydyxiahao.entity.DiscernChannels;
import com.xforceplus.ultraman.app.stydyxiahao.service.IDiscernChannelsService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-28
 */
@RestController
public class DiscernChannelsController {

  @Autowired
  private IDiscernChannelsService discernChannelsServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param discernChannels ${table.comment}
   * @return
   */
  @GetMapping("/discernchannelss" )
  public XfR getDiscernChannelss(XfPage page, DiscernChannels discernChannels) {
    return XfR.ok(discernChannelsServiceImpl.page(page, Wrappers.query(discernChannels)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/discernchannelss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(discernChannelsServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param discernChannels ${table.comment}
   * @return XfR
   */
  @PostMapping("/discernchannelss")
  public XfR save(@RequestBody DiscernChannels discernChannels) {
     return XfR.ok(discernChannelsServiceImpl.save(discernChannels));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param discernChannels ${table.comment}
   * @return XfR
   */
  @PutMapping("/discernchannelss/{id}")
  public XfR putUpdate(@RequestBody DiscernChannels discernChannels,@PathVariable Long id) {
      discernChannels.setId(id);
      return XfR.ok(discernChannelsServiceImpl.updateById(discernChannels));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param discernChannels ${table.comment}
   * @return XfR
   */
  @PatchMapping("/discernchannelss/{id}")
  public XfR patchUpdate(@RequestBody DiscernChannels discernChannels,@PathVariable Long id) {
      DiscernChannels updiscernChannels = discernChannelsServiceImpl.getById(id);
      if(updiscernChannels != null){
        updiscernChannels = ObjectCopyUtils.copyProperties(discernChannels,updiscernChannels,true);
      }
      return XfR.ok(discernChannelsServiceImpl.updateById(updiscernChannels));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/discernchannelss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(discernChannelsServiceImpl.removeById(id));
  }

  @PostMapping("/discernchannelss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "discern_channels");
     params.put("request", condition);

     return XfR.ok(discernChannelsServiceImpl.querys(params));
  }

}
