package com.xforceplus.ultraman.app.stydyxiahao.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.stydyxiahao.entity.DiscernTasks;
import com.xforceplus.ultraman.app.stydyxiahao.service.IDiscernTasksService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-28
 */
@RestController
public class DiscernTasksController {

  @Autowired
  private IDiscernTasksService discernTasksServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param discernTasks ${table.comment}
   * @return
   */
  @GetMapping("/discerntaskss" )
  public XfR getDiscernTaskss(XfPage page, DiscernTasks discernTasks) {
    return XfR.ok(discernTasksServiceImpl.page(page, Wrappers.query(discernTasks)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/discerntaskss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(discernTasksServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param discernTasks ${table.comment}
   * @return XfR
   */
  @PostMapping("/discerntaskss")
  public XfR save(@RequestBody DiscernTasks discernTasks) {
     return XfR.ok(discernTasksServiceImpl.save(discernTasks));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param discernTasks ${table.comment}
   * @return XfR
   */
  @PutMapping("/discerntaskss/{id}")
  public XfR putUpdate(@RequestBody DiscernTasks discernTasks,@PathVariable Long id) {
      discernTasks.setId(id);
      return XfR.ok(discernTasksServiceImpl.updateById(discernTasks));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param discernTasks ${table.comment}
   * @return XfR
   */
  @PatchMapping("/discerntaskss/{id}")
  public XfR patchUpdate(@RequestBody DiscernTasks discernTasks,@PathVariable Long id) {
      DiscernTasks updiscernTasks = discernTasksServiceImpl.getById(id);
      if(updiscernTasks != null){
        updiscernTasks = ObjectCopyUtils.copyProperties(discernTasks,updiscernTasks,true);
      }
      return XfR.ok(discernTasksServiceImpl.updateById(updiscernTasks));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/discerntaskss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(discernTasksServiceImpl.removeById(id));
  }

  @PostMapping("/discerntaskss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "discern_tasks");
     params.put("request", condition);

     return XfR.ok(discernTasksServiceImpl.querys(params));
  }

}
