package com.xforceplus.ultraman.app.stydyxiahao.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.stydyxiahao.entity.Samples;
import com.xforceplus.ultraman.app.stydyxiahao.service.ISamplesService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2022-09-28
 */
@RestController
public class SamplesController {

  @Autowired
  private ISamplesService samplesServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param samples ${table.comment}
   * @return
   */
  @GetMapping("/sampless" )
  public XfR getSampless(XfPage page, Samples samples) {
    return XfR.ok(samplesServiceImpl.page(page, Wrappers.query(samples)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/sampless/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(samplesServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param samples ${table.comment}
   * @return XfR
   */
  @PostMapping("/sampless")
  public XfR save(@RequestBody Samples samples) {
     return XfR.ok(samplesServiceImpl.save(samples));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param samples ${table.comment}
   * @return XfR
   */
  @PutMapping("/sampless/{id}")
  public XfR putUpdate(@RequestBody Samples samples,@PathVariable Long id) {
      samples.setId(id);
      return XfR.ok(samplesServiceImpl.updateById(samples));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param samples ${table.comment}
   * @return XfR
   */
  @PatchMapping("/sampless/{id}")
  public XfR patchUpdate(@RequestBody Samples samples,@PathVariable Long id) {
      Samples upsamples = samplesServiceImpl.getById(id);
      if(upsamples != null){
        upsamples = ObjectCopyUtils.copyProperties(samples,upsamples,true);
      }
      return XfR.ok(samplesServiceImpl.updateById(upsamples));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sampless/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(samplesServiceImpl.removeById(id));
  }

  @PostMapping("/sampless/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "samples");
     params.put("request", condition);

     return XfR.ok(samplesServiceImpl.querys(params));
  }

}
