package com.xforceplus.ultraman.app.sysapp.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * enable_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-22
 */
public enum EnableStatus {

    _0("0", "停用"),
    _1("1", "启用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    EnableStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static EnableStatus fromCode(String code) {
        return Stream.of(EnableStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
