package com.xforceplus.ultraman.app.sysapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.sysapp.entity.SystemAccount;
import com.xforceplus.ultraman.app.sysapp.service.ISystemAccountService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 账号系统对象前端控制器
 *
 * @author ultraman
 * @date 2024-06-18
 */
@RestController
public class SystemAccountController {

  @Autowired
  private ISystemAccountService systemAccountServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemAccount 账号系统对象
   * @return
   */
  @GetMapping("/systemaccounts" )
  public XfR getSystemAccounts(XfPage page, SystemAccount systemAccount) {
    return XfR.ok(systemAccountServiceImpl.page(page, Wrappers.query(systemAccount)));
  }

  /**
   * 通过id查询账号系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemaccounts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemAccountServiceImpl.getById(id));
  }

  /**
   * 新增账号系统对象
   * @param systemAccount 账号系统对象
   * @return XfR
   */
  @PostMapping("/systemaccounts")
  public XfR save(@RequestBody SystemAccount systemAccount) {
     return XfR.ok(systemAccountServiceImpl.save(systemAccount));
  }

  /**
   * 修改-传入修改后的全部数据账号系统对象
   * @param systemAccount 账号系统对象
   * @return XfR
   */
  @PutMapping("/systemaccounts/{id}")
  public XfR putUpdate(@RequestBody SystemAccount systemAccount,@PathVariable Long id) {
      systemAccount.setId(id);
      return XfR.ok(systemAccountServiceImpl.updateById(systemAccount));
  }

  /**
   * 修改-传入修改的数据账号系统对象
   * @param systemAccount 账号系统对象
   * @return XfR
   */
  @PatchMapping("/systemaccounts/{id}")
  public XfR patchUpdate(@RequestBody SystemAccount systemAccount,@PathVariable Long id) {
      SystemAccount upsystemAccount = systemAccountServiceImpl.getById(id);
      if(upsystemAccount != null){
        upsystemAccount = ObjectCopyUtils.copyProperties(systemAccount,upsystemAccount,true);
      }
      return XfR.ok(systemAccountServiceImpl.updateById(upsystemAccount));
  }

  /**
   * 通过id删除账号系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemaccounts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemAccountServiceImpl.removeById(id));
  }

  @PostMapping("/systemaccounts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_account");
     params.put("request", condition);

     return XfR.ok(systemAccountServiceImpl.querys(params));
  }

}
