package com.xforceplus.ultraman.app.sysapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.sysapp.entity.SystemRole;
import com.xforceplus.ultraman.app.sysapp.service.ISystemRoleService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 角色系统对象前端控制器
 *
 * @author ultraman
 * @date 2024-06-18
 */
@RestController
public class SystemRoleController {

  @Autowired
  private ISystemRoleService systemRoleServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemRole 角色系统对象
   * @return
   */
  @GetMapping("/systemroles" )
  public XfR getSystemRoles(XfPage page, SystemRole systemRole) {
    return XfR.ok(systemRoleServiceImpl.page(page, Wrappers.query(systemRole)));
  }

  /**
   * 通过id查询角色系统对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemroles/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemRoleServiceImpl.getById(id));
  }

  /**
   * 新增角色系统对象
   * @param systemRole 角色系统对象
   * @return XfR
   */
  @PostMapping("/systemroles")
  public XfR save(@RequestBody SystemRole systemRole) {
     return XfR.ok(systemRoleServiceImpl.save(systemRole));
  }

  /**
   * 修改-传入修改后的全部数据角色系统对象
   * @param systemRole 角色系统对象
   * @return XfR
   */
  @PutMapping("/systemroles/{id}")
  public XfR putUpdate(@RequestBody SystemRole systemRole,@PathVariable Long id) {
      systemRole.setId(id);
      return XfR.ok(systemRoleServiceImpl.updateById(systemRole));
  }

  /**
   * 修改-传入修改的数据角色系统对象
   * @param systemRole 角色系统对象
   * @return XfR
   */
  @PatchMapping("/systemroles/{id}")
  public XfR patchUpdate(@RequestBody SystemRole systemRole,@PathVariable Long id) {
      SystemRole upsystemRole = systemRoleServiceImpl.getById(id);
      if(upsystemRole != null){
        upsystemRole = ObjectCopyUtils.copyProperties(systemRole,upsystemRole,true);
      }
      return XfR.ok(systemRoleServiceImpl.updateById(upsystemRole));
  }

  /**
   * 通过id删除角色系统对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemroles/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemRoleServiceImpl.removeById(id));
  }

  @PostMapping("/systemroles/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_role");
     params.put("request", condition);

     return XfR.ok(systemRoleServiceImpl.querys(params));
  }

}
