package com.xforceplus.ultraman.app.sysapp.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.sysapp.entity.SystemWorkflowActInstance;
import com.xforceplus.ultraman.app.sysapp.service.ISystemWorkflowActInstanceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 系统流程节点实例对象前端控制器
 *
 * @author ultraman
 * @date 2024-06-18
 */
@RestController
public class SystemWorkflowActInstanceController {

  @Autowired
  private ISystemWorkflowActInstanceService systemWorkflowActInstanceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param systemWorkflowActInstance 系统流程节点实例对象
   * @return
   */
  @GetMapping("/systemworkflowactinstances" )
  public XfR getSystemWorkflowActInstances(XfPage page, SystemWorkflowActInstance systemWorkflowActInstance) {
    return XfR.ok(systemWorkflowActInstanceServiceImpl.page(page, Wrappers.query(systemWorkflowActInstance)));
  }

  /**
   * 通过id查询系统流程节点实例对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/systemworkflowactinstances/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowActInstanceServiceImpl.getById(id));
  }

  /**
   * 新增系统流程节点实例对象
   * @param systemWorkflowActInstance 系统流程节点实例对象
   * @return XfR
   */
  @PostMapping("/systemworkflowactinstances")
  public XfR save(@RequestBody SystemWorkflowActInstance systemWorkflowActInstance) {
     return XfR.ok(systemWorkflowActInstanceServiceImpl.save(systemWorkflowActInstance));
  }

  /**
   * 修改-传入修改后的全部数据系统流程节点实例对象
   * @param systemWorkflowActInstance 系统流程节点实例对象
   * @return XfR
   */
  @PutMapping("/systemworkflowactinstances/{id}")
  public XfR putUpdate(@RequestBody SystemWorkflowActInstance systemWorkflowActInstance,@PathVariable Long id) {
      systemWorkflowActInstance.setId(id);
      return XfR.ok(systemWorkflowActInstanceServiceImpl.updateById(systemWorkflowActInstance));
  }

  /**
   * 修改-传入修改的数据系统流程节点实例对象
   * @param systemWorkflowActInstance 系统流程节点实例对象
   * @return XfR
   */
  @PatchMapping("/systemworkflowactinstances/{id}")
  public XfR patchUpdate(@RequestBody SystemWorkflowActInstance systemWorkflowActInstance,@PathVariable Long id) {
      SystemWorkflowActInstance upsystemWorkflowActInstance = systemWorkflowActInstanceServiceImpl.getById(id);
      if(upsystemWorkflowActInstance != null){
        upsystemWorkflowActInstance = ObjectCopyUtils.copyProperties(systemWorkflowActInstance,upsystemWorkflowActInstance,true);
      }
      return XfR.ok(systemWorkflowActInstanceServiceImpl.updateById(upsystemWorkflowActInstance));
  }

  /**
   * 通过id删除系统流程节点实例对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/systemworkflowactinstances/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(systemWorkflowActInstanceServiceImpl.removeById(id));
  }

  @PostMapping("/systemworkflowactinstances/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "system_workflow_act_instance");
     params.put("request", condition);

     return XfR.ok(systemWorkflowActInstanceServiceImpl.querys(params));
  }

}
