package com.xforceplus.ultraman.app.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.taxwarebananaservice.entity.DeclareTaxation;
import com.xforceplus.ultraman.app.taxwarebananaservice.service.IDeclareTaxationService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 税盘报税文件汇总前端控制器
 *
 * @author ultraman
 * @date 2021-11-29
 */
@RestController
public class DeclareTaxationController {

  @Autowired
  private IDeclareTaxationService declareTaxationServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param declareTaxation 税盘报税文件汇总
   * @return
   */
  @GetMapping("/declaretaxations" )
  public XfR getDeclareTaxations(XfPage page, DeclareTaxation declareTaxation) {
    return XfR.ok(declareTaxationServiceImpl.page(page, Wrappers.query(declareTaxation)));
  }

  /**
   * 通过id查询税盘报税文件汇总
   * @param  id
   * @return XfR
   */
  @GetMapping("/declaretaxations/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(declareTaxationServiceImpl.getById(id));
  }

  /**
   * 新增税盘报税文件汇总
   * @param declareTaxation 税盘报税文件汇总
   * @return XfR
   */
  @PostMapping("/declaretaxations")
  public XfR save(@RequestBody DeclareTaxation declareTaxation) {
     return XfR.ok(declareTaxationServiceImpl.save(declareTaxation));
  }

  /**
   * 修改-传入修改后的全部数据税盘报税文件汇总
   * @param declareTaxation 税盘报税文件汇总
   * @return XfR
   */
  @PutMapping("/declaretaxations/{id}")
  public XfR putUpdate(@RequestBody DeclareTaxation declareTaxation,@PathVariable Long id) {
      declareTaxation.setId(id);
      return XfR.ok(declareTaxationServiceImpl.updateById(declareTaxation));
  }

  /**
   * 修改-传入修改的数据税盘报税文件汇总
   * @param declareTaxation 税盘报税文件汇总
   * @return XfR
   */
  @PatchMapping("/declaretaxations/{id}")
  public XfR patchUpdate(@RequestBody DeclareTaxation declareTaxation,@PathVariable Long id) {
      DeclareTaxation updeclareTaxation = declareTaxationServiceImpl.getById(id);
      if(updeclareTaxation != null){
        updeclareTaxation = ObjectCopyUtils.copyProperties(declareTaxation,updeclareTaxation,true);
      }
      return XfR.ok(declareTaxationServiceImpl.updateById(updeclareTaxation));
  }

  /**
   * 通过id删除税盘报税文件汇总
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/declaretaxations/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(declareTaxationServiceImpl.removeById(id));
  }

  @PostMapping("/declaretaxations/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "declare_taxation");
     params.put("request", condition);

     return XfR.ok(declareTaxationServiceImpl.querys(params));
  }

}
