package com.xforceplus.ultraman.app.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.taxwarebananaservice.entity.DeviceInventory;
import com.xforceplus.ultraman.app.taxwarebananaservice.service.IDeviceInventoryService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 税盘库存前端控制器
 *
 * @author ultraman
 * @date 2021-11-29
 */
@RestController
public class DeviceInventoryController {

  @Autowired
  private IDeviceInventoryService deviceInventoryServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param deviceInventory 税盘库存
   * @return
   */
  @GetMapping("/deviceinventorys" )
  public XfR getDeviceInventorys(XfPage page, DeviceInventory deviceInventory) {
    return XfR.ok(deviceInventoryServiceImpl.page(page, Wrappers.query(deviceInventory)));
  }

  /**
   * 通过id查询税盘库存
   * @param  id
   * @return XfR
   */
  @GetMapping("/deviceinventorys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(deviceInventoryServiceImpl.getById(id));
  }

  /**
   * 新增税盘库存
   * @param deviceInventory 税盘库存
   * @return XfR
   */
  @PostMapping("/deviceinventorys")
  public XfR save(@RequestBody DeviceInventory deviceInventory) {
     return XfR.ok(deviceInventoryServiceImpl.save(deviceInventory));
  }

  /**
   * 修改-传入修改后的全部数据税盘库存
   * @param deviceInventory 税盘库存
   * @return XfR
   */
  @PutMapping("/deviceinventorys/{id}")
  public XfR putUpdate(@RequestBody DeviceInventory deviceInventory,@PathVariable Long id) {
      deviceInventory.setId(id);
      return XfR.ok(deviceInventoryServiceImpl.updateById(deviceInventory));
  }

  /**
   * 修改-传入修改的数据税盘库存
   * @param deviceInventory 税盘库存
   * @return XfR
   */
  @PatchMapping("/deviceinventorys/{id}")
  public XfR patchUpdate(@RequestBody DeviceInventory deviceInventory,@PathVariable Long id) {
      DeviceInventory updeviceInventory = deviceInventoryServiceImpl.getById(id);
      if(updeviceInventory != null){
        updeviceInventory = ObjectCopyUtils.copyProperties(deviceInventory,updeviceInventory,true);
      }
      return XfR.ok(deviceInventoryServiceImpl.updateById(updeviceInventory));
  }

  /**
   * 通过id删除税盘库存
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/deviceinventorys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(deviceInventoryServiceImpl.removeById(id));
  }

  @PostMapping("/deviceinventorys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "device_inventory");
     params.put("request", condition);

     return XfR.ok(deviceInventoryServiceImpl.querys(params));
  }

}
