package com.xforceplus.ultraman.app.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.taxwarebananaservice.entity.FetchingStrategy;
import com.xforceplus.ultraman.app.taxwarebananaservice.service.IFetchingStrategyService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * 领票策略前端控制器
 *
 * @author ultraman
 * @date 2021-11-29
 */
@RestController
public class FetchingStrategyController {

  @Autowired
  private IFetchingStrategyService fetchingStrategyServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fetchingStrategy 领票策略
   * @return
   */
  @GetMapping("/fetchingstrategys" )
  public XfR getFetchingStrategys(XfPage page, FetchingStrategy fetchingStrategy) {
    return XfR.ok(fetchingStrategyServiceImpl.page(page, Wrappers.query(fetchingStrategy)));
  }

  /**
   * 通过id查询领票策略
   * @param  id
   * @return XfR
   */
  @GetMapping("/fetchingstrategys/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fetchingStrategyServiceImpl.getById(id));
  }

  /**
   * 新增领票策略
   * @param fetchingStrategy 领票策略
   * @return XfR
   */
  @PostMapping("/fetchingstrategys")
  public XfR save(@RequestBody FetchingStrategy fetchingStrategy) {
     return XfR.ok(fetchingStrategyServiceImpl.save(fetchingStrategy));
  }

  /**
   * 修改-传入修改后的全部数据领票策略
   * @param fetchingStrategy 领票策略
   * @return XfR
   */
  @PutMapping("/fetchingstrategys/{id}")
  public XfR putUpdate(@RequestBody FetchingStrategy fetchingStrategy,@PathVariable Long id) {
      fetchingStrategy.setId(id);
      return XfR.ok(fetchingStrategyServiceImpl.updateById(fetchingStrategy));
  }

  /**
   * 修改-传入修改的数据领票策略
   * @param fetchingStrategy 领票策略
   * @return XfR
   */
  @PatchMapping("/fetchingstrategys/{id}")
  public XfR patchUpdate(@RequestBody FetchingStrategy fetchingStrategy,@PathVariable Long id) {
      FetchingStrategy upfetchingStrategy = fetchingStrategyServiceImpl.getById(id);
      if(upfetchingStrategy != null){
        upfetchingStrategy = ObjectCopyUtils.copyProperties(fetchingStrategy,upfetchingStrategy,true);
      }
      return XfR.ok(fetchingStrategyServiceImpl.updateById(upfetchingStrategy));
  }

  /**
   * 通过id删除领票策略
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fetchingstrategys/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fetchingStrategyServiceImpl.removeById(id));
  }

  @PostMapping("/fetchingstrategys/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fetching_strategy");
     params.put("request", condition);

     return XfR.ok(fetchingStrategyServiceImpl.querys(params));
  }

}
