package com.xforceplus.ultraman.app.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.taxwarebananaservice.entity.Firewall;
import com.xforceplus.ultraman.app.taxwarebananaservice.service.IFirewallService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-11-29
 */
@RestController
public class FirewallController {

  @Autowired
  private IFirewallService firewallServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param firewall ${table.comment}
   * @return
   */
  @GetMapping("/firewalls" )
  public XfR getFirewalls(XfPage page, Firewall firewall) {
    return XfR.ok(firewallServiceImpl.page(page, Wrappers.query(firewall)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/firewalls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(firewallServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param firewall ${table.comment}
   * @return XfR
   */
  @PostMapping("/firewalls")
  public XfR save(@RequestBody Firewall firewall) {
     return XfR.ok(firewallServiceImpl.save(firewall));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param firewall ${table.comment}
   * @return XfR
   */
  @PutMapping("/firewalls/{id}")
  public XfR putUpdate(@RequestBody Firewall firewall,@PathVariable Long id) {
      firewall.setId(id);
      return XfR.ok(firewallServiceImpl.updateById(firewall));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param firewall ${table.comment}
   * @return XfR
   */
  @PatchMapping("/firewalls/{id}")
  public XfR patchUpdate(@RequestBody Firewall firewall,@PathVariable Long id) {
      Firewall upfirewall = firewallServiceImpl.getById(id);
      if(upfirewall != null){
        upfirewall = ObjectCopyUtils.copyProperties(firewall,upfirewall,true);
      }
      return XfR.ok(firewallServiceImpl.updateById(upfirewall));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/firewalls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(firewallServiceImpl.removeById(id));
  }

  @PostMapping("/firewalls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "firewall");
     params.put("request", condition);

     return XfR.ok(firewallServiceImpl.querys(params));
  }

}
