package com.xforceplus.ultraman.app.taxwarebananaservice.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.taxwarebananaservice.entity.MachineManage;
import com.xforceplus.ultraman.app.taxwarebananaservice.service.IMachineManageService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-11-29
 */
@RestController
public class MachineManageController {

  @Autowired
  private IMachineManageService machineManageServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param machineManage ${table.comment}
   * @return
   */
  @GetMapping("/machinemanages" )
  public XfR getMachineManages(XfPage page, MachineManage machineManage) {
    return XfR.ok(machineManageServiceImpl.page(page, Wrappers.query(machineManage)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/machinemanages/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(machineManageServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param machineManage ${table.comment}
   * @return XfR
   */
  @PostMapping("/machinemanages")
  public XfR save(@RequestBody MachineManage machineManage) {
     return XfR.ok(machineManageServiceImpl.save(machineManage));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param machineManage ${table.comment}
   * @return XfR
   */
  @PutMapping("/machinemanages/{id}")
  public XfR putUpdate(@RequestBody MachineManage machineManage,@PathVariable Long id) {
      machineManage.setId(id);
      return XfR.ok(machineManageServiceImpl.updateById(machineManage));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param machineManage ${table.comment}
   * @return XfR
   */
  @PatchMapping("/machinemanages/{id}")
  public XfR patchUpdate(@RequestBody MachineManage machineManage,@PathVariable Long id) {
      MachineManage upmachineManage = machineManageServiceImpl.getById(id);
      if(upmachineManage != null){
        upmachineManage = ObjectCopyUtils.copyProperties(machineManage,upmachineManage,true);
      }
      return XfR.ok(machineManageServiceImpl.updateById(upmachineManage));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/machinemanages/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(machineManageServiceImpl.removeById(id));
  }

  @PostMapping("/machinemanages/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "machine_manage");
     params.put("request", condition);

     return XfR.ok(machineManageServiceImpl.querys(params));
  }

}
