package com.xforceplus.ultraman.app.testsysboapp4.controller;


/**
 * testBofeign客户端
 *
 * @author ultraman
 * @date 2021-10-27
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.testsysboapp4.entity.TestBo;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "test-sysbo-app4")
public interface TestBoFeignApi {

  /**
   * 通过id查询testBo
   * @param  id
   * @return R
   */
  @GetMapping("/testBo/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增testBo
   * @param testBo testBo
   * @return R
   */
  @PostMapping("/testBo/add")
  public R save(@RequestBody TestBo testBo);

  /**
   * 修改testBo
   * @param testBo testBo
   * @return R
   */
  @PostMapping("/testBo/update")
  public R updateById(@RequestBody TestBo testBo);

  /**
   * 通过id删除testBo
   * @param  id
   * @return R
   */
  @DeleteMapping("/testBo/del/{id}" )
  public R removeById(@PathVariable Long id);

}