package com.xforceplus.ultraman.app.testtool.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testtool.entity.Tlogincompanylistconfig;
import com.xforceplus.ultraman.app.testtool.service.ITlogincompanylistconfigService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-07-10
 */
@RestController
public class TlogincompanylistconfigController {

  @Autowired
  private ITlogincompanylistconfigService tlogincompanylistconfigServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param tlogincompanylistconfig ${table.comment}
   * @return
   */
  @GetMapping("/tlogincompanylistconfigs" )
  public XfR getTlogincompanylistconfigs(XfPage page, Tlogincompanylistconfig tlogincompanylistconfig) {
    return XfR.ok(tlogincompanylistconfigServiceImpl.page(page, Wrappers.query(tlogincompanylistconfig)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/tlogincompanylistconfigs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(tlogincompanylistconfigServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param tlogincompanylistconfig ${table.comment}
   * @return XfR
   */
  @PostMapping("/tlogincompanylistconfigs")
  public XfR save(@RequestBody Tlogincompanylistconfig tlogincompanylistconfig) {
     return XfR.ok(tlogincompanylistconfigServiceImpl.save(tlogincompanylistconfig));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param tlogincompanylistconfig ${table.comment}
   * @return XfR
   */
  @PutMapping("/tlogincompanylistconfigs/{id}")
  public XfR putUpdate(@RequestBody Tlogincompanylistconfig tlogincompanylistconfig,@PathVariable Long id) {
      tlogincompanylistconfig.setId(id);
      return XfR.ok(tlogincompanylistconfigServiceImpl.updateById(tlogincompanylistconfig));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param tlogincompanylistconfig ${table.comment}
   * @return XfR
   */
  @PatchMapping("/tlogincompanylistconfigs/{id}")
  public XfR patchUpdate(@RequestBody Tlogincompanylistconfig tlogincompanylistconfig,@PathVariable Long id) {
      Tlogincompanylistconfig uptlogincompanylistconfig = tlogincompanylistconfigServiceImpl.getById(id);
      if(uptlogincompanylistconfig != null){
        uptlogincompanylistconfig = ObjectCopyUtils.copyProperties(tlogincompanylistconfig,uptlogincompanylistconfig,true);
      }
      return XfR.ok(tlogincompanylistconfigServiceImpl.updateById(uptlogincompanylistconfig));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/tlogincompanylistconfigs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(tlogincompanylistconfigServiceImpl.removeById(id));
  }

  @PostMapping("/tlogincompanylistconfigs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "tlogincompanylistconfig");
     params.put("request", condition);

     return XfR.ok(tlogincompanylistconfigServiceImpl.querys(params));
  }

}
