package com.xforceplus.ultraman.app.test051001.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 领域扩展字段系统对象
 * </p>
 *
 * @author ultraman
 * @since 2024-05-23
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SystemExtendDomainField implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 校验信息
   */
  private String validateContent;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 字段领域
   */
  private String domainConfig;

  /**
   * 编号内容
   */
  private String domainNoContent;

  /**
   * 自增编号复杂级别
   */
  private String domainNoSenior;

  /**
   * 步长
   */
  private Long step;

  /**
   * 递增类型0：严格递增1：趋势递增
   */
  private String noModel;

  /**
   * 最小值
   */
  private String minValue;

  /**
   * 最大值
   */
  private String maxValue;

  /**
   * 重置类型：0，重置，1不重置
   */
  private String resetType;

  /**
   * 公式信息
   */
  private String formulaContent;

  /**
   * 错误处理类型：1：抛异常 2：转默认值
   */
  private String failedPolicy;

  /**
   * 引用对象ID
   */
  private Long lookupBoId;

  /**
   * 应用关系ID
   */
  private Long lookupRelationId;

  /**
   * 聚合对象ID
   */
  private Long aggregationBoId;

  /**
   * 聚合对象字段ID
   */
  private Long aggregationFieldId;

  /**
   * 关系id
   */
  private Long aggregationRelationId;

  /**
   * 聚合公式类型
   */
  private String aggregationType;

  /**
   * 条件信息
   */
  private String domainCondition;

  /**
   * 条件UI配置信息
   */
  private String uiConfig;

  /**
   * 系统扩展字段id
   */
  private Long extendFieldId;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("validate_content", validateContent);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("domain_config", domainConfig);
      map.put("domain_no_content", domainNoContent);
      map.put("domain_no_senior", domainNoSenior);
      map.put("step", step);
      map.put("no_model", noModel);
      map.put("min_value", minValue);
      map.put("max_value", maxValue);
      map.put("reset_type", resetType);
      map.put("formula_content", formulaContent);
      map.put("failed_policy", failedPolicy);
      map.put("lookup_bo_id", lookupBoId);
      map.put("lookup_relation_id", lookupRelationId);
      map.put("aggregation_bo_id", aggregationBoId);
      map.put("aggregation_field_id", aggregationFieldId);
      map.put("aggregation_relation_id", aggregationRelationId);
      map.put("aggregation_type", aggregationType);
      map.put("domain_condition", domainCondition);
      map.put("ui_config", uiConfig);
      map.put("extend_field_id", extendFieldId);

      return map;
  }

  public static SystemExtendDomainField fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SystemExtendDomainField entity = new SystemExtendDomainField();
    if(map.containsKey("validate_content")) {
      Object obj = map.get("validate_content");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setValidateContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domain_config")) {
      Object obj = map.get("domain_config");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomainConfig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domain_no_content")) {
      Object obj = map.get("domain_no_content");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomainNoContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domain_no_senior")) {
      Object obj = map.get("domain_no_senior");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomainNoSenior((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("step")) {
      Object obj = map.get("step");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setStep((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setStep(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setStep(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("no_model")) {
      Object obj = map.get("no_model");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNoModel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("min_value")) {
      Object obj = map.get("min_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMinValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("max_value")) {
      Object obj = map.get("max_value");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaxValue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("reset_type")) {
      Object obj = map.get("reset_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setResetType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("formula_content")) {
      Object obj = map.get("formula_content");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFormulaContent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("failed_policy")) {
      Object obj = map.get("failed_policy");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFailedPolicy((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lookup_bo_id")) {
      Object obj = map.get("lookup_bo_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupBoId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLookupBoId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLookupBoId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("lookup_relation_id")) {
      Object obj = map.get("lookup_relation_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setLookupRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setLookupRelationId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setLookupRelationId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("aggregation_bo_id")) {
      Object obj = map.get("aggregation_bo_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAggregationBoId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAggregationBoId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAggregationBoId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("aggregation_field_id")) {
      Object obj = map.get("aggregation_field_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAggregationFieldId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAggregationFieldId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAggregationFieldId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("aggregation_relation_id")) {
      Object obj = map.get("aggregation_relation_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAggregationRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAggregationRelationId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAggregationRelationId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("aggregation_type")) {
      Object obj = map.get("aggregation_type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAggregationType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("domain_condition")) {
      Object obj = map.get("domain_condition");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDomainCondition((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ui_config")) {
      Object obj = map.get("ui_config");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUiConfig((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("extend_field_id")) {
      Object obj = map.get("extend_field_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExtendFieldId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExtendFieldId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setExtendFieldId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("validate_content")) {
      Object obj = map.get("validate_content");
      if(obj != null) {
        if(obj instanceof String) {
          this.setValidateContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domain_config")) {
      Object obj = map.get("domain_config");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomainConfig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domain_no_content")) {
      Object obj = map.get("domain_no_content");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomainNoContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domain_no_senior")) {
      Object obj = map.get("domain_no_senior");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomainNoSenior((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("step")) {
      Object obj = map.get("step");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setStep((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setStep(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setStep(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("no_model")) {
      Object obj = map.get("no_model");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNoModel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("min_value")) {
      Object obj = map.get("min_value");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMinValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("max_value")) {
      Object obj = map.get("max_value");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaxValue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("reset_type")) {
      Object obj = map.get("reset_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setResetType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("formula_content")) {
      Object obj = map.get("formula_content");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFormulaContent((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("failed_policy")) {
      Object obj = map.get("failed_policy");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFailedPolicy((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lookup_bo_id")) {
      Object obj = map.get("lookup_bo_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLookupBoId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupBoId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLookupBoId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("lookup_relation_id")) {
      Object obj = map.get("lookup_relation_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setLookupRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setLookupRelationId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setLookupRelationId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("aggregation_bo_id")) {
      Object obj = map.get("aggregation_bo_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAggregationBoId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAggregationBoId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAggregationBoId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("aggregation_field_id")) {
      Object obj = map.get("aggregation_field_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAggregationFieldId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAggregationFieldId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAggregationFieldId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("aggregation_relation_id")) {
      Object obj = map.get("aggregation_relation_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAggregationRelationId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAggregationRelationId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setAggregationRelationId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("aggregation_type")) {
      Object obj = map.get("aggregation_type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAggregationType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("domain_condition")) {
      Object obj = map.get("domain_condition");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDomainCondition((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ui_config")) {
      Object obj = map.get("ui_config");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUiConfig((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("extend_field_id")) {
      Object obj = map.get("extend_field_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExtendFieldId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExtendFieldId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setExtendFieldId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
  }
}
