package com.xforceplus.ultraman.app.testcodegen1.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * data_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public enum DataStatus {

    ADD("add", "新增"),
    DELETE("delete", "删除"),
    NOCHANGE("nochange", "无变化");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    DataStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataStatus fromCode(String code){
        switch(code) {
            case "add":
                return ADD;
            case "delete":
                return DELETE;
            case "nochange":
                return NOCHANGE;
            default:
                return null;
        }
    }
}
