package com.xforceplus.ultraman.app.testcodegen1.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * linereservation_delivery_note_status
 * </p>
 *
 * @author ultraman
 * @since 2024-05-22
 */
public enum LinereservationDeliveryNoteStatus {

    _0("0", "待预约"),
    _1("1", "预约中"),
    _2("2", "已预约"),
    _3("3", "预约异常"),
    _4("4", "取消预约");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    LinereservationDeliveryNoteStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static LinereservationDeliveryNoteStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
