package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * auth_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum AuthStatus {

    _0("0", "未抵扣"),
    _1("1", "已抵扣");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    AuthStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuthStatus fromCode(String code) {
        return Stream.of(AuthStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
