package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * compliance_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum ComplianceStatus {

    _0("0", "合规"),
    _1("1", "不合规");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    ComplianceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ComplianceStatus fromCode(String code) {
        return Stream.of(ComplianceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
