package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_risk_level
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum InvoiceRiskLevel {

    _0("0", "低"),
    _1("1", "中"),
    _2("2", "高");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceRiskLevel(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceRiskLevel fromCode(String code) {
        return Stream.of(InvoiceRiskLevel.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
