package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum InvoiceStatus {

    _0("0", "作废"),
    _1("1", "正常"),
    _2("2", "红冲");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceStatus fromCode(String code) {
        return Stream.of(InvoiceStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
