package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * mjx0613001
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum Mjx0613001 {

    _0("0", "失败"),
    _1("1", "成功");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    Mjx0613001(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static Mjx0613001 fromCode(String code) {
        return Stream.of(Mjx0613001.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
