package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * paper_ele_sign
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum PaperEleSign {

    _0("0", "纸票"),
    _1("1", "电子票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PaperEleSign(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PaperEleSign fromCode(String code) {
        return Stream.of(PaperEleSign.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
