package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_invoice_sign
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum TaxInvoiceSign {

    _0("0", "ใบกำกับภาษี"),
    _1("1", "TAX INVOICE");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxInvoiceSign(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxInvoiceSign fromCode(String code) {
        return Stream.of(TaxInvoiceSign.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
