package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * tax_rate
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum TaxRate {

    _0("0", "0"),
    _1("1", "免税"),
    _2("2", "7%");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    TaxRate(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static TaxRate fromCode(String code) {
        return Stream.of(TaxRate.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
