package com.xforceplus.ultraman.app.testddl.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * warn_status
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public enum WarnStatus {

    _0("0", "正常"),
    _1("1", "异常");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    WarnStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static WarnStatus fromCode(String code) {
        return Stream.of(WarnStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
