package com.xforceplus.ultraman.app.testddl.metadata.validator;

import com.xforceplus.ultraman.app.testddl.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.testddl.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(Mjx0328001.class)) {
            isValid = null != Mjx0328001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx0328001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0425001.class)) {
            isValid = null != Mjx0425001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx0425001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjxtest0425001.class)) {
            isValid = null != Mjxtest0425001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjxtest0425001.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PaperEleSign.class)) {
            isValid = null != PaperEleSign.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PaperEleSign.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSign.class)) {
            isValid = null != TaxInvoiceSign.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSign.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = null != ChargeUpStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxRate.class)) {
            isValid = null != TaxRate.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxRate.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = null != InvoiceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = null != AuthStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = null != SignForStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = null != MatchStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(WarnStatus.class)) {
            isValid = null != WarnStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, WarnStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = null != RedStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = null != ComplianceStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SensitiveWordLevel.class)) {
            isValid = null != SensitiveWordLevel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SensitiveWordLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceRiskLevel.class)) {
            isValid = null != InvoiceRiskLevel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceRiskLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0613001.class)) {
            isValid = null != Mjx0613001.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Mjx0613001.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
