package com.xforceplus.ultraman.app.testddl.metadata.validator;

import com.xforceplus.ultraman.app.testddl.metadata.validator.annotation.CheckUltramanEnums;

import com.xforceplus.ultraman.app.testddl.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.List;

/**
 * <p>
 * UltramanEnumsConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-10-25
 */
public class UltramanEnumsConstraintValidator implements ConstraintValidator<CheckUltramanEnums, String> {

    private final String MSG_FORMAT = "value must be formed from codes of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnums constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;
        List<String> vals = Arrays.asList(value.split(","));

        if(clazz.equals(Mjx0328001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx0328001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx0328001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0425001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx0425001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx0425001.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjxtest0425001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjxtest0425001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjxtest0425001.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceType.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PaperEleSign.class)) {
            isValid = vals.stream()
                    .filter(val -> null != PaperEleSign.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, PaperEleSign.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxInvoiceSign.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxInvoiceSign.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxInvoiceSign.class.getSimpleName());
            }
        }
        if(clazz.equals(ChargeUpStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ChargeUpStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ChargeUpStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxRate.class)) {
            isValid = vals.stream()
                    .filter(val -> null != TaxRate.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, TaxRate.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(AuthStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != AuthStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, AuthStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SignForStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SignForStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SignForStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(MatchStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != MatchStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, MatchStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(WarnStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != WarnStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, WarnStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(RedStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != RedStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, RedStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(ComplianceStatus.class)) {
            isValid = vals.stream()
                    .filter(val -> null != ComplianceStatus.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, ComplianceStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SensitiveWordLevel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != SensitiveWordLevel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, SensitiveWordLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceRiskLevel.class)) {
            isValid = vals.stream()
                    .filter(val -> null != InvoiceRiskLevel.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, InvoiceRiskLevel.class.getSimpleName());
            }
        }
        if(clazz.equals(Mjx0613001.class)) {
            isValid = vals.stream()
                    .filter(val -> null != Mjx0613001.fromCode(val))
                    .count() == vals.size();
            if(!isValid) {
                unValidMsg(context, Mjx0613001.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                        String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
