package com.xforceplus.ultraman.app.testtongyifabubushu4.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.xforceplus.ultraman.app.testtongyifabubushu4.entity.Testobject001;
import com.xforceplus.ultraman.app.testtongyifabubushu4.service.ITestobject001Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;
/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2021-07-28
 */
@RestController
public class Testobject001Controller {

  @Autowired
  private ITestobject001Service testobject001ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param testobject001 ${table.comment}
   * @return
   */
  @GetMapping("/testobject001s" )
  public XfR getTestobject001s(XfPage page, Testobject001 testobject001) {
    return XfR.ok(testobject001ServiceImpl.page(page, Wrappers.query(testobject001)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/testobject001s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(testobject001ServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param testobject001 ${table.comment}
   * @return XfR
   */
  @PostMapping("/testobject001s")
  public XfR save(@RequestBody Testobject001 testobject001) {
     return XfR.ok(testobject001ServiceImpl.save(testobject001));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param testobject001 ${table.comment}
   * @return XfR
   */
  @PutMapping("/testobject001s/{id}")
  public XfR putUpdate(@RequestBody Testobject001 testobject001,@PathVariable Long id) {
      testobject001.setId(id);
      return XfR.ok(testobject001ServiceImpl.updateById(testobject001));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param testobject001 ${table.comment}
   * @return XfR
   */
  @PatchMapping("/testobject001s/{id}")
  public XfR patchUpdate(@RequestBody Testobject001 testobject001,@PathVariable Long id) {
      Testobject001 uptestobject001 = testobject001ServiceImpl.getById(id);
      if(uptestobject001 != null){
        uptestobject001 = ObjectCopyUtils.copyProperties(testobject001,uptestobject001,true);
      }
      return XfR.ok(testobject001ServiceImpl.updateById(uptestobject001));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/testobject001s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(testobject001ServiceImpl.removeById(id));
  }

  @PostMapping("/testobject001s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "testobject001");
     params.put("request", condition);

     return XfR.ok(testobject001ServiceImpl.querys(params));
  }

}
