package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.A123test;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IA123testService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class A123testController {

  @Autowired
  private IA123testService a123testServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param a123test ${table.comment}
   * @return
   */
  @GetMapping("/a123tests" )
  public XfR getA123tests(XfPage page, A123test a123test) {
    return XfR.ok(a123testServiceImpl.page(page, Wrappers.query(a123test)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/a123tests/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(a123testServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param a123test ${table.comment}
   * @return XfR
   */
  @PostMapping("/a123tests")
  public XfR save(@RequestBody A123test a123test) {
     return XfR.ok(a123testServiceImpl.save(a123test));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param a123test ${table.comment}
   * @return XfR
   */
  @PutMapping("/a123tests/{id}")
  public XfR putUpdate(@RequestBody A123test a123test,@PathVariable Long id) {
      a123test.setId(id);
      return XfR.ok(a123testServiceImpl.updateById(a123test));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param a123test ${table.comment}
   * @return XfR
   */
  @PatchMapping("/a123tests/{id}")
  public XfR patchUpdate(@RequestBody A123test a123test,@PathVariable Long id) {
      A123test upa123test = a123testServiceImpl.getById(id);
      if(upa123test != null){
        upa123test = ObjectCopyUtils.copyProperties(a123test,upa123test,true);
      }
      return XfR.ok(a123testServiceImpl.updateById(upa123test));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/a123tests/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(a123testServiceImpl.removeById(id));
  }

  @PostMapping("/a123tests/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "a123test");
     params.put("request", condition);

     return XfR.ok(a123testServiceImpl.querys(params));
  }

}
