package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Allclass;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IAllclassService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * allclass前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class AllclassController {

  @Autowired
  private IAllclassService allclassServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param allclass allclass
   * @return
   */
  @GetMapping("/allclasss" )
  public XfR getAllclasss(XfPage page, Allclass allclass) {
    return XfR.ok(allclassServiceImpl.page(page, Wrappers.query(allclass)));
  }

  /**
   * 通过id查询allclass
   * @param  id
   * @return XfR
   */
  @GetMapping("/allclasss/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(allclassServiceImpl.getById(id));
  }

  /**
   * 新增allclass
   * @param allclass allclass
   * @return XfR
   */
  @PostMapping("/allclasss")
  public XfR save(@RequestBody Allclass allclass) {
     return XfR.ok(allclassServiceImpl.save(allclass));
  }

  /**
   * 修改-传入修改后的全部数据allclass
   * @param allclass allclass
   * @return XfR
   */
  @PutMapping("/allclasss/{id}")
  public XfR putUpdate(@RequestBody Allclass allclass,@PathVariable Long id) {
      allclass.setId(id);
      return XfR.ok(allclassServiceImpl.updateById(allclass));
  }

  /**
   * 修改-传入修改的数据allclass
   * @param allclass allclass
   * @return XfR
   */
  @PatchMapping("/allclasss/{id}")
  public XfR patchUpdate(@RequestBody Allclass allclass,@PathVariable Long id) {
      Allclass upallclass = allclassServiceImpl.getById(id);
      if(upallclass != null){
        upallclass = ObjectCopyUtils.copyProperties(allclass,upallclass,true);
      }
      return XfR.ok(allclassServiceImpl.updateById(upallclass));
  }

  /**
   * 通过id删除allclass
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/allclasss/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(allclassServiceImpl.removeById(id));
  }

  @PostMapping("/allclasss/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "allclass");
     params.put("request", condition);

     return XfR.ok(allclassServiceImpl.querys(params));
  }

}
