package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Beijuheduxiang;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IBeijuheduxiangService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 被聚合对象前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class BeijuheduxiangController {

  @Autowired
  private IBeijuheduxiangService beijuheduxiangServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beijuheduxiang 被聚合对象
   * @return
   */
  @GetMapping("/beijuheduxiangs" )
  public XfR getBeijuheduxiangs(XfPage page, Beijuheduxiang beijuheduxiang) {
    return XfR.ok(beijuheduxiangServiceImpl.page(page, Wrappers.query(beijuheduxiang)));
  }

  /**
   * 通过id查询被聚合对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/beijuheduxiangs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beijuheduxiangServiceImpl.getById(id));
  }

  /**
   * 新增被聚合对象
   * @param beijuheduxiang 被聚合对象
   * @return XfR
   */
  @PostMapping("/beijuheduxiangs")
  public XfR save(@RequestBody Beijuheduxiang beijuheduxiang) {
     return XfR.ok(beijuheduxiangServiceImpl.save(beijuheduxiang));
  }

  /**
   * 修改-传入修改后的全部数据被聚合对象
   * @param beijuheduxiang 被聚合对象
   * @return XfR
   */
  @PutMapping("/beijuheduxiangs/{id}")
  public XfR putUpdate(@RequestBody Beijuheduxiang beijuheduxiang,@PathVariable Long id) {
      beijuheduxiang.setId(id);
      return XfR.ok(beijuheduxiangServiceImpl.updateById(beijuheduxiang));
  }

  /**
   * 修改-传入修改的数据被聚合对象
   * @param beijuheduxiang 被聚合对象
   * @return XfR
   */
  @PatchMapping("/beijuheduxiangs/{id}")
  public XfR patchUpdate(@RequestBody Beijuheduxiang beijuheduxiang,@PathVariable Long id) {
      Beijuheduxiang upbeijuheduxiang = beijuheduxiangServiceImpl.getById(id);
      if(upbeijuheduxiang != null){
        upbeijuheduxiang = ObjectCopyUtils.copyProperties(beijuheduxiang,upbeijuheduxiang,true);
      }
      return XfR.ok(beijuheduxiangServiceImpl.updateById(upbeijuheduxiang));
  }

  /**
   * 通过id删除被聚合对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beijuheduxiangs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beijuheduxiangServiceImpl.removeById(id));
  }

  @PostMapping("/beijuheduxiangs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beijuheduxiang");
     params.put("request", condition);

     return XfR.ok(beijuheduxiangServiceImpl.querys(params));
  }

}
