package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Beilookup0120;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IBeilookup0120Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * beilookup0120前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Beilookup0120Controller {

  @Autowired
  private IBeilookup0120Service beilookup0120ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beilookup0120 beilookup0120
   * @return
   */
  @GetMapping("/beilookup0120s" )
  public XfR getBeilookup0120s(XfPage page, Beilookup0120 beilookup0120) {
    return XfR.ok(beilookup0120ServiceImpl.page(page, Wrappers.query(beilookup0120)));
  }

  /**
   * 通过id查询beilookup0120
   * @param  id
   * @return XfR
   */
  @GetMapping("/beilookup0120s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beilookup0120ServiceImpl.getById(id));
  }

  /**
   * 新增beilookup0120
   * @param beilookup0120 beilookup0120
   * @return XfR
   */
  @PostMapping("/beilookup0120s")
  public XfR save(@RequestBody Beilookup0120 beilookup0120) {
     return XfR.ok(beilookup0120ServiceImpl.save(beilookup0120));
  }

  /**
   * 修改-传入修改后的全部数据beilookup0120
   * @param beilookup0120 beilookup0120
   * @return XfR
   */
  @PutMapping("/beilookup0120s/{id}")
  public XfR putUpdate(@RequestBody Beilookup0120 beilookup0120,@PathVariable Long id) {
      beilookup0120.setId(id);
      return XfR.ok(beilookup0120ServiceImpl.updateById(beilookup0120));
  }

  /**
   * 修改-传入修改的数据beilookup0120
   * @param beilookup0120 beilookup0120
   * @return XfR
   */
  @PatchMapping("/beilookup0120s/{id}")
  public XfR patchUpdate(@RequestBody Beilookup0120 beilookup0120,@PathVariable Long id) {
      Beilookup0120 upbeilookup0120 = beilookup0120ServiceImpl.getById(id);
      if(upbeilookup0120 != null){
        upbeilookup0120 = ObjectCopyUtils.copyProperties(beilookup0120,upbeilookup0120,true);
      }
      return XfR.ok(beilookup0120ServiceImpl.updateById(upbeilookup0120));
  }

  /**
   * 通过id删除beilookup0120
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beilookup0120s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beilookup0120ServiceImpl.removeById(id));
  }

  @PostMapping("/beilookup0120s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beilookup0120");
     params.put("request", condition);

     return XfR.ok(beilookup0120ServiceImpl.querys(params));
  }

}
