package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Beilookup0406;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IBeilookup0406Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * beilookup0406前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Beilookup0406Controller {

  @Autowired
  private IBeilookup0406Service beilookup0406ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beilookup0406 beilookup0406
   * @return
   */
  @GetMapping("/beilookup0406s" )
  public XfR getBeilookup0406s(XfPage page, Beilookup0406 beilookup0406) {
    return XfR.ok(beilookup0406ServiceImpl.page(page, Wrappers.query(beilookup0406)));
  }

  /**
   * 通过id查询beilookup0406
   * @param  id
   * @return XfR
   */
  @GetMapping("/beilookup0406s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beilookup0406ServiceImpl.getById(id));
  }

  /**
   * 新增beilookup0406
   * @param beilookup0406 beilookup0406
   * @return XfR
   */
  @PostMapping("/beilookup0406s")
  public XfR save(@RequestBody Beilookup0406 beilookup0406) {
     return XfR.ok(beilookup0406ServiceImpl.save(beilookup0406));
  }

  /**
   * 修改-传入修改后的全部数据beilookup0406
   * @param beilookup0406 beilookup0406
   * @return XfR
   */
  @PutMapping("/beilookup0406s/{id}")
  public XfR putUpdate(@RequestBody Beilookup0406 beilookup0406,@PathVariable Long id) {
      beilookup0406.setId(id);
      return XfR.ok(beilookup0406ServiceImpl.updateById(beilookup0406));
  }

  /**
   * 修改-传入修改的数据beilookup0406
   * @param beilookup0406 beilookup0406
   * @return XfR
   */
  @PatchMapping("/beilookup0406s/{id}")
  public XfR patchUpdate(@RequestBody Beilookup0406 beilookup0406,@PathVariable Long id) {
      Beilookup0406 upbeilookup0406 = beilookup0406ServiceImpl.getById(id);
      if(upbeilookup0406 != null){
        upbeilookup0406 = ObjectCopyUtils.copyProperties(beilookup0406,upbeilookup0406,true);
      }
      return XfR.ok(beilookup0406ServiceImpl.updateById(upbeilookup0406));
  }

  /**
   * 通过id删除beilookup0406
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beilookup0406s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beilookup0406ServiceImpl.removeById(id));
  }

  @PostMapping("/beilookup0406s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beilookup0406");
     params.put("request", condition);

     return XfR.ok(beilookup0406ServiceImpl.querys(params));
  }

}
