package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Beilookup041501;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IBeilookup041501Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * beilookup041501前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Beilookup041501Controller {

  @Autowired
  private IBeilookup041501Service beilookup041501ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beilookup041501 beilookup041501
   * @return
   */
  @GetMapping("/beilookup041501s" )
  public XfR getBeilookup041501s(XfPage page, Beilookup041501 beilookup041501) {
    return XfR.ok(beilookup041501ServiceImpl.page(page, Wrappers.query(beilookup041501)));
  }

  /**
   * 通过id查询beilookup041501
   * @param  id
   * @return XfR
   */
  @GetMapping("/beilookup041501s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beilookup041501ServiceImpl.getById(id));
  }

  /**
   * 新增beilookup041501
   * @param beilookup041501 beilookup041501
   * @return XfR
   */
  @PostMapping("/beilookup041501s")
  public XfR save(@RequestBody Beilookup041501 beilookup041501) {
     return XfR.ok(beilookup041501ServiceImpl.save(beilookup041501));
  }

  /**
   * 修改-传入修改后的全部数据beilookup041501
   * @param beilookup041501 beilookup041501
   * @return XfR
   */
  @PutMapping("/beilookup041501s/{id}")
  public XfR putUpdate(@RequestBody Beilookup041501 beilookup041501,@PathVariable Long id) {
      beilookup041501.setId(id);
      return XfR.ok(beilookup041501ServiceImpl.updateById(beilookup041501));
  }

  /**
   * 修改-传入修改的数据beilookup041501
   * @param beilookup041501 beilookup041501
   * @return XfR
   */
  @PatchMapping("/beilookup041501s/{id}")
  public XfR patchUpdate(@RequestBody Beilookup041501 beilookup041501,@PathVariable Long id) {
      Beilookup041501 upbeilookup041501 = beilookup041501ServiceImpl.getById(id);
      if(upbeilookup041501 != null){
        upbeilookup041501 = ObjectCopyUtils.copyProperties(beilookup041501,upbeilookup041501,true);
      }
      return XfR.ok(beilookup041501ServiceImpl.updateById(upbeilookup041501));
  }

  /**
   * 通过id删除beilookup041501
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beilookup041501s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beilookup041501ServiceImpl.removeById(id));
  }

  @PostMapping("/beilookup041501s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beilookup041501");
     params.put("request", condition);

     return XfR.ok(beilookup041501ServiceImpl.querys(params));
  }

}
