package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Beilookup1227;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IBeilookup1227Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 测试被lookup对象下载前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Beilookup1227Controller {

  @Autowired
  private IBeilookup1227Service beilookup1227ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beilookup1227 测试被lookup对象下载
   * @return
   */
  @GetMapping("/beilookup1227s" )
  public XfR getBeilookup1227s(XfPage page, Beilookup1227 beilookup1227) {
    return XfR.ok(beilookup1227ServiceImpl.page(page, Wrappers.query(beilookup1227)));
  }

  /**
   * 通过id查询测试被lookup对象下载
   * @param  id
   * @return XfR
   */
  @GetMapping("/beilookup1227s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beilookup1227ServiceImpl.getById(id));
  }

  /**
   * 新增测试被lookup对象下载
   * @param beilookup1227 测试被lookup对象下载
   * @return XfR
   */
  @PostMapping("/beilookup1227s")
  public XfR save(@RequestBody Beilookup1227 beilookup1227) {
     return XfR.ok(beilookup1227ServiceImpl.save(beilookup1227));
  }

  /**
   * 修改-传入修改后的全部数据测试被lookup对象下载
   * @param beilookup1227 测试被lookup对象下载
   * @return XfR
   */
  @PutMapping("/beilookup1227s/{id}")
  public XfR putUpdate(@RequestBody Beilookup1227 beilookup1227,@PathVariable Long id) {
      beilookup1227.setId(id);
      return XfR.ok(beilookup1227ServiceImpl.updateById(beilookup1227));
  }

  /**
   * 修改-传入修改的数据测试被lookup对象下载
   * @param beilookup1227 测试被lookup对象下载
   * @return XfR
   */
  @PatchMapping("/beilookup1227s/{id}")
  public XfR patchUpdate(@RequestBody Beilookup1227 beilookup1227,@PathVariable Long id) {
      Beilookup1227 upbeilookup1227 = beilookup1227ServiceImpl.getById(id);
      if(upbeilookup1227 != null){
        upbeilookup1227 = ObjectCopyUtils.copyProperties(beilookup1227,upbeilookup1227,true);
      }
      return XfR.ok(beilookup1227ServiceImpl.updateById(upbeilookup1227));
  }

  /**
   * 通过id删除测试被lookup对象下载
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beilookup1227s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beilookup1227ServiceImpl.removeById(id));
  }

  @PostMapping("/beilookup1227s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beilookup1227");
     params.put("request", condition);

     return XfR.ok(beilookup1227ServiceImpl.querys(params));
  }

}
