package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Beilookup1230;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IBeilookup1230Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 被lookup对象1230前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Beilookup1230Controller {

  @Autowired
  private IBeilookup1230Service beilookup1230ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beilookup1230 被lookup对象1230
   * @return
   */
  @GetMapping("/beilookup1230s" )
  public XfR getBeilookup1230s(XfPage page, Beilookup1230 beilookup1230) {
    return XfR.ok(beilookup1230ServiceImpl.page(page, Wrappers.query(beilookup1230)));
  }

  /**
   * 通过id查询被lookup对象1230
   * @param  id
   * @return XfR
   */
  @GetMapping("/beilookup1230s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beilookup1230ServiceImpl.getById(id));
  }

  /**
   * 新增被lookup对象1230
   * @param beilookup1230 被lookup对象1230
   * @return XfR
   */
  @PostMapping("/beilookup1230s")
  public XfR save(@RequestBody Beilookup1230 beilookup1230) {
     return XfR.ok(beilookup1230ServiceImpl.save(beilookup1230));
  }

  /**
   * 修改-传入修改后的全部数据被lookup对象1230
   * @param beilookup1230 被lookup对象1230
   * @return XfR
   */
  @PutMapping("/beilookup1230s/{id}")
  public XfR putUpdate(@RequestBody Beilookup1230 beilookup1230,@PathVariable Long id) {
      beilookup1230.setId(id);
      return XfR.ok(beilookup1230ServiceImpl.updateById(beilookup1230));
  }

  /**
   * 修改-传入修改的数据被lookup对象1230
   * @param beilookup1230 被lookup对象1230
   * @return XfR
   */
  @PatchMapping("/beilookup1230s/{id}")
  public XfR patchUpdate(@RequestBody Beilookup1230 beilookup1230,@PathVariable Long id) {
      Beilookup1230 upbeilookup1230 = beilookup1230ServiceImpl.getById(id);
      if(upbeilookup1230 != null){
        upbeilookup1230 = ObjectCopyUtils.copyProperties(beilookup1230,upbeilookup1230,true);
      }
      return XfR.ok(beilookup1230ServiceImpl.updateById(upbeilookup1230));
  }

  /**
   * 通过id删除被lookup对象1230
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beilookup1230s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beilookup1230ServiceImpl.removeById(id));
  }

  @PostMapping("/beilookup1230s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beilookup1230");
     params.put("request", condition);

     return XfR.ok(beilookup1230ServiceImpl.querys(params));
  }

}
