package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Beilookup2;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IBeilookup2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * beilookup2前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Beilookup2Controller {

  @Autowired
  private IBeilookup2Service beilookup2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param beilookup2 beilookup2
   * @return
   */
  @GetMapping("/beilookup2s" )
  public XfR getBeilookup2s(XfPage page, Beilookup2 beilookup2) {
    return XfR.ok(beilookup2ServiceImpl.page(page, Wrappers.query(beilookup2)));
  }

  /**
   * 通过id查询beilookup2
   * @param  id
   * @return XfR
   */
  @GetMapping("/beilookup2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(beilookup2ServiceImpl.getById(id));
  }

  /**
   * 新增beilookup2
   * @param beilookup2 beilookup2
   * @return XfR
   */
  @PostMapping("/beilookup2s")
  public XfR save(@RequestBody Beilookup2 beilookup2) {
     return XfR.ok(beilookup2ServiceImpl.save(beilookup2));
  }

  /**
   * 修改-传入修改后的全部数据beilookup2
   * @param beilookup2 beilookup2
   * @return XfR
   */
  @PutMapping("/beilookup2s/{id}")
  public XfR putUpdate(@RequestBody Beilookup2 beilookup2,@PathVariable Long id) {
      beilookup2.setId(id);
      return XfR.ok(beilookup2ServiceImpl.updateById(beilookup2));
  }

  /**
   * 修改-传入修改的数据beilookup2
   * @param beilookup2 beilookup2
   * @return XfR
   */
  @PatchMapping("/beilookup2s/{id}")
  public XfR patchUpdate(@RequestBody Beilookup2 beilookup2,@PathVariable Long id) {
      Beilookup2 upbeilookup2 = beilookup2ServiceImpl.getById(id);
      if(upbeilookup2 != null){
        upbeilookup2 = ObjectCopyUtils.copyProperties(beilookup2,upbeilookup2,true);
      }
      return XfR.ok(beilookup2ServiceImpl.updateById(upbeilookup2));
  }

  /**
   * 通过id删除beilookup2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/beilookup2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(beilookup2ServiceImpl.removeById(id));
  }

  @PostMapping("/beilookup2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "beilookup2");
     params.put("request", condition);

     return XfR.ok(beilookup2ServiceImpl.querys(params));
  }

}
