package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Classall;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IClassallService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * classall前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class ClassallController {

  @Autowired
  private IClassallService classallServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param classall classall
   * @return
   */
  @GetMapping("/classalls" )
  public XfR getClassalls(XfPage page, Classall classall) {
    return XfR.ok(classallServiceImpl.page(page, Wrappers.query(classall)));
  }

  /**
   * 通过id查询classall
   * @param  id
   * @return XfR
   */
  @GetMapping("/classalls/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(classallServiceImpl.getById(id));
  }

  /**
   * 新增classall
   * @param classall classall
   * @return XfR
   */
  @PostMapping("/classalls")
  public XfR save(@RequestBody Classall classall) {
     return XfR.ok(classallServiceImpl.save(classall));
  }

  /**
   * 修改-传入修改后的全部数据classall
   * @param classall classall
   * @return XfR
   */
  @PutMapping("/classalls/{id}")
  public XfR putUpdate(@RequestBody Classall classall,@PathVariable Long id) {
      classall.setId(id);
      return XfR.ok(classallServiceImpl.updateById(classall));
  }

  /**
   * 修改-传入修改的数据classall
   * @param classall classall
   * @return XfR
   */
  @PatchMapping("/classalls/{id}")
  public XfR patchUpdate(@RequestBody Classall classall,@PathVariable Long id) {
      Classall upclassall = classallServiceImpl.getById(id);
      if(upclassall != null){
        upclassall = ObjectCopyUtils.copyProperties(classall,upclassall,true);
      }
      return XfR.ok(classallServiceImpl.updateById(upclassall));
  }

  /**
   * 通过id删除classall
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/classalls/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(classallServiceImpl.removeById(id));
  }

  @PostMapping("/classalls/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "classall");
     params.put("request", condition);

     return XfR.ok(classallServiceImpl.querys(params));
  }

}
