package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Ddy033101;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IDdy033101Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ddy033101前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Ddy033101Controller {

  @Autowired
  private IDdy033101Service ddy033101ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param ddy033101 ddy033101
   * @return
   */
  @GetMapping("/ddy033101s" )
  public XfR getDdy033101s(XfPage page, Ddy033101 ddy033101) {
    return XfR.ok(ddy033101ServiceImpl.page(page, Wrappers.query(ddy033101)));
  }

  /**
   * 通过id查询ddy033101
   * @param  id
   * @return XfR
   */
  @GetMapping("/ddy033101s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(ddy033101ServiceImpl.getById(id));
  }

  /**
   * 新增ddy033101
   * @param ddy033101 ddy033101
   * @return XfR
   */
  @PostMapping("/ddy033101s")
  public XfR save(@RequestBody Ddy033101 ddy033101) {
     return XfR.ok(ddy033101ServiceImpl.save(ddy033101));
  }

  /**
   * 修改-传入修改后的全部数据ddy033101
   * @param ddy033101 ddy033101
   * @return XfR
   */
  @PutMapping("/ddy033101s/{id}")
  public XfR putUpdate(@RequestBody Ddy033101 ddy033101,@PathVariable Long id) {
      ddy033101.setId(id);
      return XfR.ok(ddy033101ServiceImpl.updateById(ddy033101));
  }

  /**
   * 修改-传入修改的数据ddy033101
   * @param ddy033101 ddy033101
   * @return XfR
   */
  @PatchMapping("/ddy033101s/{id}")
  public XfR patchUpdate(@RequestBody Ddy033101 ddy033101,@PathVariable Long id) {
      Ddy033101 upddy033101 = ddy033101ServiceImpl.getById(id);
      if(upddy033101 != null){
        upddy033101 = ObjectCopyUtils.copyProperties(ddy033101,upddy033101,true);
      }
      return XfR.ok(ddy033101ServiceImpl.updateById(upddy033101));
  }

  /**
   * 通过id删除ddy033101
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/ddy033101s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(ddy033101ServiceImpl.removeById(id));
  }

  @PostMapping("/ddy033101s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ddy033101");
     params.put("request", condition);

     return XfR.ok(ddy033101ServiceImpl.querys(params));
  }

}
