package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Fec;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IFecService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class FecController {

  @Autowired
  private IFecService fecServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fec ${table.comment}
   * @return
   */
  @GetMapping("/fecs" )
  public XfR getFecs(XfPage page, Fec fec) {
    return XfR.ok(fecServiceImpl.page(page, Wrappers.query(fec)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/fecs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fecServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fec ${table.comment}
   * @return XfR
   */
  @PostMapping("/fecs")
  public XfR save(@RequestBody Fec fec) {
     return XfR.ok(fecServiceImpl.save(fec));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fec ${table.comment}
   * @return XfR
   */
  @PutMapping("/fecs/{id}")
  public XfR putUpdate(@RequestBody Fec fec,@PathVariable Long id) {
      fec.setId(id);
      return XfR.ok(fecServiceImpl.updateById(fec));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fec ${table.comment}
   * @return XfR
   */
  @PatchMapping("/fecs/{id}")
  public XfR patchUpdate(@RequestBody Fec fec,@PathVariable Long id) {
      Fec upfec = fecServiceImpl.getById(id);
      if(upfec != null){
        upfec = ObjectCopyUtils.copyProperties(fec,upfec,true);
      }
      return XfR.ok(fecServiceImpl.updateById(upfec));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fecs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fecServiceImpl.removeById(id));
  }

  @PostMapping("/fecs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fec");
     params.put("request", condition);

     return XfR.ok(fecServiceImpl.querys(params));
  }

}
