package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Fenzutest0120;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IFenzutest0120Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 测试分组功能前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Fenzutest0120Controller {

  @Autowired
  private IFenzutest0120Service fenzutest0120ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fenzutest0120 测试分组功能
   * @return
   */
  @GetMapping("/fenzutest0120s" )
  public XfR getFenzutest0120s(XfPage page, Fenzutest0120 fenzutest0120) {
    return XfR.ok(fenzutest0120ServiceImpl.page(page, Wrappers.query(fenzutest0120)));
  }

  /**
   * 通过id查询测试分组功能
   * @param  id
   * @return XfR
   */
  @GetMapping("/fenzutest0120s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fenzutest0120ServiceImpl.getById(id));
  }

  /**
   * 新增测试分组功能
   * @param fenzutest0120 测试分组功能
   * @return XfR
   */
  @PostMapping("/fenzutest0120s")
  public XfR save(@RequestBody Fenzutest0120 fenzutest0120) {
     return XfR.ok(fenzutest0120ServiceImpl.save(fenzutest0120));
  }

  /**
   * 修改-传入修改后的全部数据测试分组功能
   * @param fenzutest0120 测试分组功能
   * @return XfR
   */
  @PutMapping("/fenzutest0120s/{id}")
  public XfR putUpdate(@RequestBody Fenzutest0120 fenzutest0120,@PathVariable Long id) {
      fenzutest0120.setId(id);
      return XfR.ok(fenzutest0120ServiceImpl.updateById(fenzutest0120));
  }

  /**
   * 修改-传入修改的数据测试分组功能
   * @param fenzutest0120 测试分组功能
   * @return XfR
   */
  @PatchMapping("/fenzutest0120s/{id}")
  public XfR patchUpdate(@RequestBody Fenzutest0120 fenzutest0120,@PathVariable Long id) {
      Fenzutest0120 upfenzutest0120 = fenzutest0120ServiceImpl.getById(id);
      if(upfenzutest0120 != null){
        upfenzutest0120 = ObjectCopyUtils.copyProperties(fenzutest0120,upfenzutest0120,true);
      }
      return XfR.ok(fenzutest0120ServiceImpl.updateById(upfenzutest0120));
  }

  /**
   * 通过id删除测试分组功能
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/fenzutest0120s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fenzutest0120ServiceImpl.removeById(id));
  }

  @PostMapping("/fenzutest0120s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fenzutest0120");
     params.put("request", condition);

     return XfR.ok(fenzutest0120ServiceImpl.querys(params));
  }

}
