package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Fep;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IFepService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class FepController {

  @Autowired
  private IFepService fepServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param fep ${table.comment}
   * @return
   */
  @GetMapping("/feps" )
  public XfR getFeps(XfPage page, Fep fep) {
    return XfR.ok(fepServiceImpl.page(page, Wrappers.query(fep)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/feps/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(fepServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param fep ${table.comment}
   * @return XfR
   */
  @PostMapping("/feps")
  public XfR save(@RequestBody Fep fep) {
     return XfR.ok(fepServiceImpl.save(fep));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param fep ${table.comment}
   * @return XfR
   */
  @PutMapping("/feps/{id}")
  public XfR putUpdate(@RequestBody Fep fep,@PathVariable Long id) {
      fep.setId(id);
      return XfR.ok(fepServiceImpl.updateById(fep));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param fep ${table.comment}
   * @return XfR
   */
  @PatchMapping("/feps/{id}")
  public XfR patchUpdate(@RequestBody Fep fep,@PathVariable Long id) {
      Fep upfep = fepServiceImpl.getById(id);
      if(upfep != null){
        upfep = ObjectCopyUtils.copyProperties(fep,upfep,true);
      }
      return XfR.ok(fepServiceImpl.updateById(upfep));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/feps/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(fepServiceImpl.removeById(id));
  }

  @PostMapping("/feps/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "fep");
     params.put("request", condition);

     return XfR.ok(fepServiceImpl.querys(params));
  }

}
