package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.FlowLog;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IFlowLogService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class FlowLogController {

  @Autowired
  private IFlowLogService flowLogServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param flowLog ${table.comment}
   * @return
   */
  @GetMapping("/flowlogs" )
  public XfR getFlowLogs(XfPage page, FlowLog flowLog) {
    return XfR.ok(flowLogServiceImpl.page(page, Wrappers.query(flowLog)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/flowlogs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(flowLogServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param flowLog ${table.comment}
   * @return XfR
   */
  @PostMapping("/flowlogs")
  public XfR save(@RequestBody FlowLog flowLog) {
     return XfR.ok(flowLogServiceImpl.save(flowLog));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param flowLog ${table.comment}
   * @return XfR
   */
  @PutMapping("/flowlogs/{id}")
  public XfR putUpdate(@RequestBody FlowLog flowLog,@PathVariable Long id) {
      flowLog.setId(id);
      return XfR.ok(flowLogServiceImpl.updateById(flowLog));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param flowLog ${table.comment}
   * @return XfR
   */
  @PatchMapping("/flowlogs/{id}")
  public XfR patchUpdate(@RequestBody FlowLog flowLog,@PathVariable Long id) {
      FlowLog upflowLog = flowLogServiceImpl.getById(id);
      if(upflowLog != null){
        upflowLog = ObjectCopyUtils.copyProperties(flowLog,upflowLog,true);
      }
      return XfR.ok(flowLogServiceImpl.updateById(upflowLog));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/flowlogs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(flowLogServiceImpl.removeById(id));
  }

  @PostMapping("/flowlogs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "flow_log");
     params.put("request", condition);

     return XfR.ok(flowLogServiceImpl.querys(params));
  }

}
