package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Guanxiduix1;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IGuanxiduix1Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 主对象前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Guanxiduix1Controller {

  @Autowired
  private IGuanxiduix1Service guanxiduix1ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param guanxiduix1 主对象
   * @return
   */
  @GetMapping("/guanxiduix1s" )
  public XfR getGuanxiduix1s(XfPage page, Guanxiduix1 guanxiduix1) {
    return XfR.ok(guanxiduix1ServiceImpl.page(page, Wrappers.query(guanxiduix1)));
  }

  /**
   * 通过id查询主对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/guanxiduix1s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(guanxiduix1ServiceImpl.getById(id));
  }

  /**
   * 新增主对象
   * @param guanxiduix1 主对象
   * @return XfR
   */
  @PostMapping("/guanxiduix1s")
  public XfR save(@RequestBody Guanxiduix1 guanxiduix1) {
     return XfR.ok(guanxiduix1ServiceImpl.save(guanxiduix1));
  }

  /**
   * 修改-传入修改后的全部数据主对象
   * @param guanxiduix1 主对象
   * @return XfR
   */
  @PutMapping("/guanxiduix1s/{id}")
  public XfR putUpdate(@RequestBody Guanxiduix1 guanxiduix1,@PathVariable Long id) {
      guanxiduix1.setId(id);
      return XfR.ok(guanxiduix1ServiceImpl.updateById(guanxiduix1));
  }

  /**
   * 修改-传入修改的数据主对象
   * @param guanxiduix1 主对象
   * @return XfR
   */
  @PatchMapping("/guanxiduix1s/{id}")
  public XfR patchUpdate(@RequestBody Guanxiduix1 guanxiduix1,@PathVariable Long id) {
      Guanxiduix1 upguanxiduix1 = guanxiduix1ServiceImpl.getById(id);
      if(upguanxiduix1 != null){
        upguanxiduix1 = ObjectCopyUtils.copyProperties(guanxiduix1,upguanxiduix1,true);
      }
      return XfR.ok(guanxiduix1ServiceImpl.updateById(upguanxiduix1));
  }

  /**
   * 通过id删除主对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/guanxiduix1s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(guanxiduix1ServiceImpl.removeById(id));
  }

  @PostMapping("/guanxiduix1s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "guanxiduix1");
     params.put("request", condition);

     return XfR.ok(guanxiduix1ServiceImpl.querys(params));
  }

}
