package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Guanxiduix2;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IGuanxiduix2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 明细对象前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Guanxiduix2Controller {

  @Autowired
  private IGuanxiduix2Service guanxiduix2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param guanxiduix2 明细对象
   * @return
   */
  @GetMapping("/guanxiduix2s" )
  public XfR getGuanxiduix2s(XfPage page, Guanxiduix2 guanxiduix2) {
    return XfR.ok(guanxiduix2ServiceImpl.page(page, Wrappers.query(guanxiduix2)));
  }

  /**
   * 通过id查询明细对象
   * @param  id
   * @return XfR
   */
  @GetMapping("/guanxiduix2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(guanxiduix2ServiceImpl.getById(id));
  }

  /**
   * 新增明细对象
   * @param guanxiduix2 明细对象
   * @return XfR
   */
  @PostMapping("/guanxiduix2s")
  public XfR save(@RequestBody Guanxiduix2 guanxiduix2) {
     return XfR.ok(guanxiduix2ServiceImpl.save(guanxiduix2));
  }

  /**
   * 修改-传入修改后的全部数据明细对象
   * @param guanxiduix2 明细对象
   * @return XfR
   */
  @PutMapping("/guanxiduix2s/{id}")
  public XfR putUpdate(@RequestBody Guanxiduix2 guanxiduix2,@PathVariable Long id) {
      guanxiduix2.setId(id);
      return XfR.ok(guanxiduix2ServiceImpl.updateById(guanxiduix2));
  }

  /**
   * 修改-传入修改的数据明细对象
   * @param guanxiduix2 明细对象
   * @return XfR
   */
  @PatchMapping("/guanxiduix2s/{id}")
  public XfR patchUpdate(@RequestBody Guanxiduix2 guanxiduix2,@PathVariable Long id) {
      Guanxiduix2 upguanxiduix2 = guanxiduix2ServiceImpl.getById(id);
      if(upguanxiduix2 != null){
        upguanxiduix2 = ObjectCopyUtils.copyProperties(guanxiduix2,upguanxiduix2,true);
      }
      return XfR.ok(guanxiduix2ServiceImpl.updateById(upguanxiduix2));
  }

  /**
   * 通过id删除明细对象
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/guanxiduix2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(guanxiduix2ServiceImpl.removeById(id));
  }

  @PostMapping("/guanxiduix2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "guanxiduix2");
     params.put("request", condition);

     return XfR.ok(guanxiduix2ServiceImpl.querys(params));
  }

}
