package com.xforceplus.ultraman.app.testzichanguanli1224.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.testzichanguanli1224.entity.Jianyipeizhi2;
import com.xforceplus.ultraman.app.testzichanguanli1224.service.IJianyipeizhi2Service;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * jianyipeizhi2前端控制器
 *
 * @author ultraman
 * @date 2024-05-22
 */
@RestController
public class Jianyipeizhi2Controller {

  @Autowired
  private IJianyipeizhi2Service jianyipeizhi2ServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jianyipeizhi2 jianyipeizhi2
   * @return
   */
  @GetMapping("/jianyipeizhi2s" )
  public XfR getJianyipeizhi2s(XfPage page, Jianyipeizhi2 jianyipeizhi2) {
    return XfR.ok(jianyipeizhi2ServiceImpl.page(page, Wrappers.query(jianyipeizhi2)));
  }

  /**
   * 通过id查询jianyipeizhi2
   * @param  id
   * @return XfR
   */
  @GetMapping("/jianyipeizhi2s/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jianyipeizhi2ServiceImpl.getById(id));
  }

  /**
   * 新增jianyipeizhi2
   * @param jianyipeizhi2 jianyipeizhi2
   * @return XfR
   */
  @PostMapping("/jianyipeizhi2s")
  public XfR save(@RequestBody Jianyipeizhi2 jianyipeizhi2) {
     return XfR.ok(jianyipeizhi2ServiceImpl.save(jianyipeizhi2));
  }

  /**
   * 修改-传入修改后的全部数据jianyipeizhi2
   * @param jianyipeizhi2 jianyipeizhi2
   * @return XfR
   */
  @PutMapping("/jianyipeizhi2s/{id}")
  public XfR putUpdate(@RequestBody Jianyipeizhi2 jianyipeizhi2,@PathVariable Long id) {
      jianyipeizhi2.setId(id);
      return XfR.ok(jianyipeizhi2ServiceImpl.updateById(jianyipeizhi2));
  }

  /**
   * 修改-传入修改的数据jianyipeizhi2
   * @param jianyipeizhi2 jianyipeizhi2
   * @return XfR
   */
  @PatchMapping("/jianyipeizhi2s/{id}")
  public XfR patchUpdate(@RequestBody Jianyipeizhi2 jianyipeizhi2,@PathVariable Long id) {
      Jianyipeizhi2 upjianyipeizhi2 = jianyipeizhi2ServiceImpl.getById(id);
      if(upjianyipeizhi2 != null){
        upjianyipeizhi2 = ObjectCopyUtils.copyProperties(jianyipeizhi2,upjianyipeizhi2,true);
      }
      return XfR.ok(jianyipeizhi2ServiceImpl.updateById(upjianyipeizhi2));
  }

  /**
   * 通过id删除jianyipeizhi2
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jianyipeizhi2s/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jianyipeizhi2ServiceImpl.removeById(id));
  }

  @PostMapping("/jianyipeizhi2s/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jianyipeizhi2");
     params.put("request", condition);

     return XfR.ok(jianyipeizhi2ServiceImpl.querys(params));
  }

}
